/**
* Copyright (C) 2012, Crestron Electronics, Inc.  All rights reserved.
* No part of this software may be reproduced in any form, machine or natural,
* without the express written consent of Crestron.
*
* \file     (See the name of this file).
* \brief    (See comments in the associated header file).
* \detail   (None).
* \warning  (None).
* \note     (None).
* \author   Arto Kiremitdjian.
* \date     3/21/2012.
* \review   Richard Ting on 3/23/12: rev. 138408.
**/
//-------------------------------------------------------------------------
// Include files.

#include <linux/i2c.h>
#include "IrdI2cIF.h" // What class to implement.

//-------------------------------------------------------------------------
// Preprocessor defines.

//-------------------------------------------------------------------------
// Type definitions.

//-------------------------------------------------------------------------
// Local data/variables (declarations and definitions).

//-------------------------------------------------------------------------
// Local function declarations.

//-------------------------------------------------------------------------
// Local function definitions.

/**
* \brief    Reads data from the IR transceiver.
* \param    pBuf - Output buffer for whatever data have been read.
* \param    length - Size of output buffer: Number of bytes.
* \return   intean: Whether this function succeeded.
* \author   Arto Kiremitdjian.
* \date     3/21/2012
*/
int IrdI2cInterfaceRead (struct i2c_client *client, unsigned char *const pBuf, unsigned short const length)
{
	int retval = 0; // ASSUME negative outcome.
    // Prepare I2C packet(s) for the desired operation.
	struct i2c_msg packet = {}; // I2C packet, To populate its fields....

    //printk(KERN_ERR "+%s(%08Xh, %u).\n", __FUNCTION__,(unsigned int)pBuf, (unsigned int)length);

    // Verify parameter(s).
    //  - Skipping range-check of 'length', because it is passed to a callee
    //    as-is, without any data-type conversions.  Callee can verify it.
    if (NULL != pBuf)
    {
		packet.addr = client->addr;
		packet.flags = I2C_M_RD;
		packet.buf = pBuf;
		packet.len = length;

		retval = i2c_transfer(client->adapter, &packet, 1);
		if(retval < 0)
			printk(KERN_ERR "%s: FAILED %d\n",__FUNCTION__, retval);
		else
			retval = length;
    }
    else
    {
    	printk(KERN_ERR "%s: BAD parameter: NULL pointer to buffer.\n",__FUNCTION__);
        // Intentionally do nothing else: Already assumed negative outcome.
    }
    //printk(KERN_ERR "-%s = int %u.\n",__FUNCTION__,retval);
    return retval;
}

/**
* \brief    Write data to the IR transceiver.
* \param    pBuf - Input buffer containing the data to write.
* \param    length - Size of input buffer: Number of bytes to write.
* \return   intean: Whether this function succeeded.
* \author   Arto Kiremitdjian.
* \date     3/21/2012
*/
int IrdI2cInterfaceWrite (struct i2c_client *client, unsigned char const *const pBuf, unsigned short const length)
{
	int retval = 0; // ASSUME failure.
    struct i2c_msg packet = {}; // I2C packet, To populate its fields....

    //printk(KERN_DEBUG "+%s(%08Xh, %u).\n", __FUNCTION__,(unsigned int)pBuf, (unsigned int)length);

    // Verify parameter(s).
    //  - Skipping range-check of 'length', because it is passed to a callee
    //    as-is, without any data-type conversions.  Callee can verify it.
    if (NULL != pBuf)
    {
		// Prepare I2C packet(s) for the desired operation.
    	packet.addr = client->addr;; //TODO not this address?
		packet.flags = 0;
		packet.buf = (unsigned char*)pBuf;
		packet.len = length;

		retval = i2c_transfer(client->adapter, &packet, 1);
		if(retval < 0)
			printk(KERN_ERR "%s: FAILED %d\n",__FUNCTION__, retval);
		else
			retval = length;
    }
    else
    	printk(KERN_ERR "%s: BAD parameter: NULL pointer to buffer.\n",__FUNCTION__);

	//printk(KERN_DEBUG "-%s = int %u.\n",__FUNCTION__,retval);
    return retval;
}

